


<?php
header("Content-Type: application/json");

$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode(["success" => false, "error" => $e->getMessage()]);
    exit;
}

$video_id = $_POST['video_id'] ?? null;
$usernames = $_POST['usernames'] ?? '';

if (!$video_id || empty($usernames)) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid data"
    ]);
    exit;
}

/* 🔥 "Rishi,Rohan,Ravi" → array */
$userList = array_map('trim', explode(",", $usernames));

$stmt = $pdo->prepare(
    "INSERT INTO video_watches (video_id, username) VALUES (?, ?)"
);

$count = 0;
foreach ($userList as $user) {
    if ($user !== '') {
        $stmt->execute([$video_id, $user]);
        $count++;
    }
}

echo json_encode([
    "success" => true,
    "inserted" => $count
]);
