<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get the data from the POST request
$Screen = isset($_POST['Screen']) ? $_POST['Screen'] : '';
$username = isset($_GET['username']) ? $_GET['username'] : ''; // Get username from query parameters

// Connect to the MySQL database
$host = 'localhost';
$user = 'root';
$password = '';
$database = 'dreams';

$conn = mysqli_connect($host, $user, $password, $database);

if (!$conn) {
    die(json_encode(['error' => 'Connection failed: ' . mysqli_connect_error()]));
}

// Check if the username is provided and is a valid string
if (empty($username) || !is_string($username)) {
    die(json_encode(['error' => 'Invalid username provided']));
}

// Prepare the SQL statement to prevent SQL injection
$stmt = $conn->prepare("UPDATE login SET `Screen` = ? WHERE username = ?");
if ($stmt === false) {
    die(json_encode(['error' => 'Prepare failed: ' . $conn->error]));
}

// Bind parameters (assuming Screen is a string and username is also a string)
$stmt->bind_param("ss", $Screen, $username);

// Execute the statement
if ($stmt->execute()) {
    echo json_encode(['success' => 'Record updated successfully']);
} else {
    echo json_encode(['error' => 'Error: ' . $stmt->error]);
}

// Close the statement and connection
$stmt->close();
mysqli_close($conn);
?>