

<?php
header("Access-Control-Allow-Origin: *"); // Allow requests from any origin
header("Content-Type: application/json; charset=UTF-8"); // Set response type to JSON

// Database connection details
$servername = "localhost"; // Your database server
$username = "root"; // Your database username
$password = ""; // Your database password
$dbname = "dreams"; // Your database name

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(['error' => 'Connection failed: ' . $conn->connect_error]));
}

// Get user_id from query parameters and ensure it's provided
if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => 'user_id is required']);
    exit;
}

$user_id = intval($_GET['user_id']); // Fetch and sanitize user_id

// Base URL for media files
$base_url = 'http://10.91.25.51/dreams/uploads/';

// Fetch videos for the specified user_id
$sql = "SELECT * FROM video WHERE user_id = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(['error' => 'Failed to prepare SQL statement: ' . $conn->error]);
    exit;
}

$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();

$videos = array();

if ($res->num_rows > 0) {
    while ($video = $res->fetch_assoc()) {
        $video_id = $video['id'];

        // Count views for each video
        $count_sql = "SELECT COUNT(*) AS view_count FROM video_watches WHERE video_id = ?";
        $count_stmt = $conn->prepare($count_sql);

        if (!$count_stmt) {
            echo json_encode(['error' => 'Failed to prepare view count SQL statement: ' . $conn->error]);
            exit;
        }

        $count_stmt->bind_param("i", $video_id);
        $count_stmt->execute();
        $count_res = $count_stmt->get_result();
        $view_count = $count_res->fetch_assoc()['view_count'];

        // Count likes for each video
        $like_count_sql = "SELECT COUNT(*) AS like_count FROM likese WHERE post_id = ?";
        $like_count_stmt = $conn->prepare($like_count_sql);

        if (!$like_count_stmt) {
            echo json_encode(['error' => 'Failed to prepare like count SQL statement: ' . $conn->error]);
            exit;
        }

        $like_count_stmt->bind_param("i", $video_id);
        $like_count_stmt->execute();
        $like_count_res = $like_count_stmt->get_result();
        $like_count = $like_count_res->fetch_assoc()['like_count'];

        // Add video details along with view count and like count
        $videos[] = array(
            'id' => $video['id'],
            'caption' => $video['caption'],
            'reels_video' => $base_url . $video['reels_video'], // Prepend base URL
            'thumbnail' => $base_url . $video['thumbnail'], // Prepend base URL
            'created_at' => $video['created_at'],
            'view_count' => $view_count,
            'like_count' => $like_count,
        );
    }
}

// Return the videos as JSON
echo json_encode($videos);

// Close the database connection
$stmt->close();
$conn->close();
?>