

<?php
// Configuration
$db_host = 'localhost';
$db_username = 'root';
$db_password = '';
$db_name = 'dreams';

// Create connection
$conn = new mysqli($db_host, $db_username, $db_password, $db_name);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get user ID from URL parameter
$user_id = $_GET['user_id'];

// Prepare the query
$stmt = $conn->prepare("SELECT l.id, l.username,l.reels_video
                        FROM login l 
                        JOIN follows f ON l.id = f.user_id
                        WHERE f.follow_id = ?");

// Bind the user ID parameter
$stmt->bind_param("i", $user_id);

// Execute the query
$stmt->execute();

// Get the result
$result = $stmt->get_result();

// Fetch the followers
$followers = array();
while ($row = $result->fetch_assoc()) {
    $followers[] = array(
        'username' => $row['username'],
        'reels_video' => $row['reels_video'],
        'user_id' => $row['id']
    );
}

// Close the statement and connection
$stmt->close();
$conn->close();

// Print the followers in JSON format
echo json_encode($followers);
?>