
<?php
// Configuration
$db_host = 'localhost';
$db_username = 'root';
$db_password = '';
$db_name = 'dreams';

// Base URL for media files
$base_url = "http://10.91.25.51/dreams/";

// Create connection
$conn = new mysqli($db_host, $db_username, $db_password, $db_name);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

// Get user ID from URL parameter
if (!isset($_GET['user_id'])) {
    die(json_encode(["error" => "user_id parameter is required"]));
}

$user_id = (int)$_GET['user_id'];

// Prepare the query
$stmt = $conn->prepare("SELECT l.id, l.username, l.reels_video, l.name, l.caption
                        FROM login l 
                        JOIN follows f ON l.id = f.user_id
                        WHERE f.follow_id = ?");

if (!$stmt) {
    die(json_encode(["error" => "Prepare failed: " . $conn->error]));
}

// Bind the user ID parameter
$stmt->bind_param("i", $user_id);

// Execute the query
if (!$stmt->execute()) {
    die(json_encode(["error" => "Execute failed: " . $stmt->error]));
}

// Get the result
$result = $stmt->get_result();

// Fetch the followers
$followers = array();
while ($row = $result->fetch_assoc()) {
    // Add base URL to reels_video if it exists
    $reels_video = !empty($row['reels_video']) ? $base_url . $row['reels_video'] : null;
    
    $followers[] = array(
        'username' => $row['username'],
        'reels_video' => $reels_video,
        'user_id' => $row['id'],
        'name' => $row['name'],
        'caption' => $row['caption']
    );
}

// Close the statement and connection
$stmt->close();
$conn->close();

// Set content type and return JSON
header('Content-Type: application/json');
echo json_encode($followers);
?>