<?php
// Database connection settings
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

// Create a PDO instance
$pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);

// Set the PDO error mode to exception
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Retrieve the user ID from the GET parameter
$user_id = $_GET['user_id'];

// Define the SQL query
$sql = "
SELECT 
    rv.id,
    rv.created_at,	                        -- Video ID
    rv.caption,                   -- Video caption
    rv.reels_video,               -- Video file path
    rv.user_id,                   -- User ID of the video creator
    l.username,                   -- Username of the video creator
    l.name,                       -- Name of the video creator
    l.caption AS user_caption,    -- User caption
    l.reels_video AS user_reels_video, -- User video file path
    COALESCE(like_counts.like_count, 0) AS like_count,  -- Count of likes for the video
    COUNT(vw.id) AS view_count     -- Count of views for the video
FROM reels_videose rv
LEFT JOIN user_reelsvideo_interactions uri ON rv.id = uri.video_id AND uri.user_id = :user_id
LEFT JOIN login l ON rv.user_id = l.id
LEFT JOIN video_watches vw ON rv.id = vw.video_id  -- Join to count views
LEFT JOIN (
    SELECT post_id, COUNT(*) AS like_count
    FROM likese
    GROUP BY post_id
) AS like_counts ON rv.id = like_counts.post_id  -- Subquery to count likes
WHERE uri.video_id IS NULL OR uri.viewed = 0
GROUP BY rv.id, l.username, l.name, l.caption, l.reels_video
";

// Prepare the SQL query
$stmt = $pdo->prepare($sql);

// Bind the user ID parameter
$stmt->bindParam(':user_id', $user_id);

// Execute the SQL query
$stmt->execute();

// Fetch the results
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Close the PDO connection
$pdo = null;

// Return the results in JSON format
header('Content-Type: application/json');
echo json_encode($results);
?>