


<?php
header("Content-Type: application/json");
require_once 'db_connect.php';

// 🌐 Base URL for media
$baseUrl = "http://10.56.185.51/dreams/uploads/";

// ✅ Get user_id from request
$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;

$response = [
    "success" => false,
    "stories" => []
];

if ($userId) {
    $sql = "SELECT id, user_id, media_url, media_type, created_at, music_url, gradient_index 
            FROM stories 
            WHERE user_id = ? 
            ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    $stories = [];

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $stories[] = [
                "id" => (int)$row["id"],
                "user_id" => (int)$row["user_id"],
                "media_url" => $baseUrl . $row["media_url"],
                "media_type" => $row["media_type"],
                "created_at" => $row["created_at"],
                "music_url" => $row["music_url"] ? $baseUrl . $row["music_url"] : null,
                "gradient_index" => (int)$row["gradient_index"],
            ];
        }
    }

    $response["success"] = true;
    $response["stories"] = $stories;
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
