





<?php
// DB connect
$servername = "localhost";
$username   = "root";
$password   = "";
$dbname     = "chat_bot";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]));
}

header("Content-Type: application/json");

$user_id = $_POST['user_id'] ?? null;
$other_user_id = $_POST['other_user_id'] ?? null;
$allowed = $_POST['allowed'] ?? null;

if (!$user_id || !$other_user_id || $allowed === null) {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
    exit;
}

// 🔹 पहले check करो user_allow में entry है या नहीं
$check = $conn->prepare("SELECT id FROM user_allow WHERE user_id=? AND other_user_id=?");
$check->bind_param("ii", $user_id, $other_user_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    // 🔹 अगर entry है तो update करो
    $update = $conn->prepare("UPDATE user_allow SET allowed=?, updated_at=NOW() WHERE user_id=? AND other_user_id=?");
    $update->bind_param("iii", $allowed, $user_id, $other_user_id);
    if ($update->execute()) {
        echo json_encode(["success" => true, "message" => "Permission updated"]);
    } else {
        echo json_encode(["success" => false, "message" => "Update failed"]);
    }
} else {
    // 🔹 अगर entry नहीं है तो insert करो
    $insert = $conn->prepare("INSERT INTO user_allow (user_id, other_user_id, allowed, created_at, updated_at) VALUES (?, ?, ?, NOW(), NOW())");
    $insert->bind_param("iii", $user_id, $other_user_id, $allowed);
    if ($insert->execute()) {
        echo json_encode(["success" => true, "message" => "Permission added"]);
    } else {
        echo json_encode(["success" => false, "message" => "Insert failed"]);
    }
}
?>
