<?php
// DB कनेक्शन
$pdo = new PDO("mysql:host=localhost;dbname=dreams", "root", "");

// video_id गेट से लो
$video_id = isset($_GET['video_id']) ? $_GET['video_id'] : null;

if (!$video_id) {
    http_response_code(400);
    echo json_encode(["error" => "video_id is required"]);
    exit;
}

// SQL: चुने गए video_id के लिए दिनवार views
$stmt = $pdo->prepare("
    SELECT 
        DATE(watch_date) as day,
        COUNT(*) as views
    FROM 
        video_watches
    WHERE
        video_id = :video_id
    GROUP BY 
        DATE(watch_date)
    ORDER BY
        day ASC
");

$stmt->execute(['video_id' => $video_id]);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// JSON भेजें
header('Content-Type: application/json');
echo json_encode($data);
?>
