



<?php
// DB connect
$servername = "localhost";
$username   = "root";
$password   = "";
$dbname     = "chat_bot";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "DB Connection failed"]));
}

header("Content-Type: application/json");

$user_id = $_POST['user_id'] ?? null;
$action = $_POST['action'] ?? null; // "clear_category" OR "clear_conversation"

if (!$user_id || !$action) {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
    exit;
}

if ($action === "clear_category") {
    $stmt = $conn->prepare("DELETE FROM category_frequency WHERE user_id=?");
    $stmt->bind_param("s", $user_id);
    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Category frequency cleared"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to clear category frequency"]);
    }
} elseif ($action === "clear_conversation") {
    $stmt = $conn->prepare("DELETE FROM user_conversations WHERE user_id=?");
    $stmt->bind_param("s", $user_id);
    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "User conversations cleared"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to clear user conversations"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid action"]);
}
