

<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Database connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die(json_encode(["status" => "error", "message" => $e->getMessage()]));
}

//$video_id = $_POST['video_id'] ?? '';
$video_id = $_POST['video_id'] ?? $_GET['video_id'] ?? '';

if (!empty($video_id)) {
    // Check if ID exists
    $check = $pdo->prepare("SELECT id, click_count FROM videos WHERE id = ?");
    $check->execute([$video_id]);

    if ($check->rowCount() > 0) {
        // ID exists → Update click_count
        $stmt = $pdo->prepare("UPDATE videos SET click_count = click_count + 1 WHERE id = ?");
        $stmt->execute([$video_id]);
    } else {
        // ID doesn't exist → Insert new row
        $insert = $pdo->prepare("INSERT INTO videos (id, click_count) VALUES (?, 1)");
        $insert->execute([$video_id]);
    }

    // Get updated click_count
    $clickCountStmt = $pdo->prepare("SELECT click_count FROM videos WHERE id = ?");
    $clickCountStmt->execute([$video_id]);
    $clickCount = (int)$clickCountStmt->fetchColumn();

    // Count messages where post_id matches video_id
    $msgCountStmt = $pdo->prepare("SELECT COUNT(*) FROM messages WHERE post_id = ?");
    $msgCountStmt->execute([$video_id]);
    $messagesCount = (int)$msgCountStmt->fetchColumn();

    // Count comments where post_id matches video_id
    $commentCountStmt = $pdo->prepare("SELECT COUNT(*) FROM commentse WHERE post_id = ?");
    $commentCountStmt->execute([$video_id]);
    $commentsCount = (int)$commentCountStmt->fetchColumn();

    echo json_encode([
        "status" => "success",
        "video_id" => $video_id,
        "click_count" => $clickCount,
        "messages_count" => $messagesCount,
        "comments_count" => $commentsCount
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "No video_id provided"]);
}
