
<?php
$host = 'localhost';
$dbname = 'dreams';
$username = 'root'; // Replace with your actual database username
$password = ''; // Replace with your actual database password

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Enable exceptions for errors
} catch (PDOException $e) {
    die(json_encode(["success" => false, "message" => "Connection failed: " . $e->getMessage()]));
}

// Get the ID from the request
$id = isset($_POST['id']) ? intval($_POST['id']) : 0;

// Check if ID is valid
if ($id > 0) {
    try {
        // Prepare and execute the statement
        $stmt = $connection->prepare("DELETE FROM reels_videose WHERE id = ?");
        $stmt->execute([$id]);

        // Check if any rows were affected
        if ($stmt->rowCount() > 0) {
            echo json_encode(["success" => true, "message" => "Record deleted successfully."]);
        } else {
            echo json_encode(["success" => false, "message" => "No record found with the provided ID."]);
        }
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => "Error deleting record: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid ID provided."]);
}

// Close the connection (optional)
$connection = null;
?>