<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'db_connection.php';

$currentUserId = $_POST['current_user_id'] ?? 0;
$receiverId = $_POST['receiver_id'] ?? 0;

if (!$currentUserId || !$receiverId) {
    echo json_encode(['success' => false, 'message' => 'Missing user id']);
    exit;
}

try {
    // Delete all messages between the two users
    $stmt = $pdo->prepare("DELETE FROM messages WHERE 
        (sender_id = :currentUserId AND receiver_id = :receiverId) OR
        (sender_id = :receiverId AND receiver_id = :currentUserId)");
    $stmt->execute(['currentUserId' => $currentUserId, 'receiverId' => $receiverId]);

    // Optionally delete the profile (if this is meant to fully remove the user)
    $stmt = $pdo->prepare("DELETE FROM login WHERE id = :receiverId");
    $stmt->execute(['receiverId' => $receiverId]);

    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
