
<?php

require("connection.php");

// Check if 'username' is provided in the GET request
if (isset($_GET['username'])) {
    $username = $_GET['username'];

    // Prepare the SQL query to select the user by username
    $makeQuery = "SELECT * FROM login WHERE username = :username";
    $statement = $connection->prepare($makeQuery);
    
    // Bind the username parameter to prevent SQL injection
    $statement->bindParam(':username', $username);
    
    $statement->execute();
    $myarray = array();

    // Fetch the results
    while ($resultsFrom = $statement->fetch()) {
        array_push(
            $myarray, array(
                "id" => $resultsFrom['id'],
                "username" => $resultsFrom['username'],
                "name" => $resultsFrom['name'],
                "password" => $resultsFrom['password'],
                "caption" => $resultsFrom['caption'],
            )
        );
    }

    // Check if any user was found
    if (empty($myarray)) {
        echo json_encode(array("message" => "User  not found."));
    } else {
        echo json_encode($myarray);
    }
} else {
    echo json_encode(array("message" => "No username provided."));
}

?>