<?php
// Set JSON response
header('Content-Type: application/json');

// DB credentials
$host = "localhost";
$user = "root";
$password = "";
$database = "dreams";

// Connect
$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed"]);
    exit;
}

// Get video_id from GET
$video_id = isset($_GET['video_id']) ? $_GET['video_id'] : null;

if ($video_id !== null) {
    $video_id = $conn->real_escape_string($video_id);

    // Total views
    $countQuery = "SELECT COUNT(*) AS view_count FROM video_watches WHERE video_id = '$video_id'";
    $countResult = $conn->query($countQuery);
    $view_count = 0;
    if ($countResult && $row = $countResult->fetch_assoc()) {
        $view_count = (int)$row['view_count'];
    }

    // Latest view date
    $dateQuery = "SELECT watch_date FROM video_watches WHERE video_id = '$video_id' ORDER BY watch_date DESC LIMIT 1";
    $dateResult = $conn->query($dateQuery);
    $watch_day = null;
    $watch_year = null;

    if ($dateResult && $row = $dateResult->fetch_assoc()) {
        $rawDate = strtotime($row['watch_date']);
        $watch_day = date("j F", $rawDate);   // 👉 4 June
        $watch_year = date("Y", $rawDate);    // 👉 2025
    }

    echo json_encode([
        "video_id" => $video_id,
        "views" => $view_count,
        "watch_day" => $watch_day,
        "watch_year" => $watch_year
    ]);
} else {
    http_response_code(400);
    echo json_encode(["error" => "Missing video_id parameter"]);
}

$conn->close();
?>
