


<?php
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get user ID and private status from request
    $user_id = $_POST['user_id'] ?? null;
    $is_private = $_POST['is_private'] ?? null;

    if ($user_id !== null && $is_private !== null) {
        // Use prepared statement to prevent SQL injection
        $query = "UPDATE login SET is_private = :is_private WHERE id = :user_id";
        $stmt = $connection->prepare($query);
        $stmt->bindParam(':is_private', $is_private, PDO::PARAM_INT);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            echo json_encode(['is_private' => $is_private]);
        } else {
            echo json_encode(['error' => 'Failed to update private status']);
        }
    } else {
        echo json_encode(['error' => 'Missing parameters']);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
