

<?php
// Database configuration
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "dreams";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        "success" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]));
}

// Get POST data
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
$post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : null;

if (!$user_id || !$post_id) {
    echo json_encode([
        "success" => false,
        "message" => "Missing user_id or post_id"
    ]);
    exit;
}

// Insert into `save` table
$stmt = $conn->prepare("INSERT INTO save (user_id, post_id) VALUES (?, ?)");
$stmt->bind_param("ii", $user_id, $post_id);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Video saved successfully"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to save video"
    ]);
}

$stmt->close();
$conn->close();
?>