

<?php
// Database config
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';
$base_url = "http://10.91.25.51/dreams/"; // Base URL

// Create connection
$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        "status" => "error",
        "message" => "Database connection failed: " . $conn->connect_error
    ]));
}

// Get user_id from request
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id > 0) {
    $sql = "SELECT rv.*
            FROM save s
            JOIN reels_videose rv ON s.post_id = rv.id
            WHERE s.user_id = ? AND rv.media_type = 'video'
            ORDER BY s.saved_at DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $videos = [];
    while ($row = $result->fetch_assoc()) {
        // Add full URL to video and thumbnail
        if (!empty($row['reels_video'])) {
            $row['reels_video'] = $base_url . $row['reels_video'];
        }
        if (!empty($row['thumbnail'])) {
            $row['thumbnail'] = $base_url . $row['thumbnail'];
        }
        $videos[] = $row;
    }

    echo json_encode([
        "status" => "success",
        "data" => $videos
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid user_id"
    ]);
}

$conn->close();
?>
