<?php
header("Content-Type: application/json");

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'dreams');

class Database {
    private $pdo;
    private static $instance = null;

    private function __construct() {
        try {
            $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
                PDO::ATTR_PERSISTENT         => true
            ];

            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            // Log the error securely
            error_log("Database connection failed: " . $e->getMessage());
            
            // Return a JSON error response
            die(json_encode([
                'success' => false,
                'message' => 'Database connection error',
                'error_code' => 'DB_CONNECTION_FAILED'
            ]));
        }
    }

    public static function getInstance() {
        if (!self::$instance) {
            self::$instance = new Database();
        }
        return self::$instance->pdo;
    }

    // Prevent cloning and serialization
    private function __clone() {}
    public function __wakeup() {
        throw new Exception("Cannot unserialize a singleton");
    }
}

// Create a global PDO instance
$pdo = Database::getInstance();

// Test connection (remove in production)
try {
    $pdo->query("SELECT 1");
} catch (PDOException $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Database test query failed',
        'error' => $e->getMessage()
    ]));
}

// Helper function for JSON responses
function jsonResponse($success, $message = '', $data = []) {
    $response = ['success' => $success];
    if ($message) $response['message'] = $message;
    if (!empty($data)) $response['data'] = $data;
    return json_encode($response);
}
?>