

<?php
include "db_conn.php";

if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => 'user_id is required']);
    exit;
}

$user_id = intval($_GET['user_id']);
$baseUrl = "http://10.37.96.51/dreams/";

// 🔹 Fetch posts: user की अपनी OR वो posts जिनमें वो tagged है (permission=1)
$sql = "
    SELECT rv.id, rv.caption, rv.reels_video AS media_file, rv.media_type, rv.thumbnail,
           rv.music_url, rv.created_at,
           l.username, l.name, l.bio, l.reels_video AS profile_video
    FROM reels_videose rv
    JOIN login l ON rv.user_id = l.id
    WHERE rv.user_id = ? 
       OR rv.id IN (
            SELECT post_id 
            FROM tagged_friends_reels_videose 
            WHERE user_id = ? AND permission = 1
       )
    ORDER BY rv.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$res = $stmt->get_result();

$media = [];

if ($res->num_rows > 0) {
    while ($row = $res->fetch_assoc()) {
        $media_id = $row['id'];

        // 🔹 Views count (only for video type)
        $view_count = 0;
        if ($row['media_type'] === 'video') {
            $count_sql = "SELECT COUNT(*) AS view_count FROM video_watches WHERE video_id = ?";
            $count_stmt = $conn->prepare($count_sql);
            $count_stmt->bind_param("i", $media_id);
            $count_stmt->execute();
            $count_res = $count_stmt->get_result();
            $view_count = $count_res->fetch_assoc()['view_count'] ?? 0;
            $count_stmt->close();
        }

        // 🔹 Likes count
        $like_count_sql = "SELECT COUNT(*) AS like_count FROM likese WHERE post_id = ?";
        $like_count_stmt = $conn->prepare($like_count_sql);
        $like_count_stmt->bind_param("i", $media_id);
        $like_count_stmt->execute();
        $like_count_res = $like_count_stmt->get_result();
        $like_count = $like_count_res->fetch_assoc()['like_count'] ?? 0;
        $like_count_stmt->close();

        // 🔹 Thumbnail (only for video type)
        $thumbnail = null;
        if ($row['media_type'] === 'video' && !empty($row['thumbnail'])) {
            $thumbnail = $baseUrl . $row['thumbnail'];
        }

        // 🔹 Tagged Friends Data (permission=1 only)
        $tagged_sql = "
            SELECT tfrv.user_id, l.username, l.reels_video AS profile_video
            FROM tagged_friends_reels_videose tfrv
            JOIN login l ON tfrv.user_id = l.id
            WHERE tfrv.post_id = ? AND tfrv.permission = 1
        ";
        $tagged_stmt = $conn->prepare($tagged_sql);
        $tagged_stmt->bind_param("i", $media_id);
        $tagged_stmt->execute();
        $tagged_res = $tagged_stmt->get_result();

        $tagged_friends = [];
        while ($tagged = $tagged_res->fetch_assoc()) {
            $tagged_friends[] = [
                'tagged_user_id' => $tagged['user_id'],
                'tagged_username' => $tagged['username'],
                'tagged_profile_video' => $baseUrl . $tagged['profile_video']
            ];
        }
        $tagged_stmt->close();

        // 🔹 Final array push
        $media[] = [
            'id' => (int)$media_id,
            'caption' => $row['caption'],
            'file_url' => $baseUrl . $row['media_file'],
            'thumbnail' => $thumbnail,
            'media_type' => $row['media_type'],
            'view_count' => (int)$view_count,
            'like_count' => (int)$like_count,
            'music_url' => $row['music_url'] ? $row['music_url'] : null,
            'created_at' => $row['created_at'],
            'username' => $row['username'],
            'name' => $row['name'],
            'bio' => $row['bio'],
            'profile_video' => $baseUrl . $row['profile_video'],
            'tagged_friends' => $tagged_friends
        ];
    }
}

echo json_encode($media, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
