
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    // Create a PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);

    // Set the PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_POST['caption']) && isset($_POST['image_id']) && isset($_POST['name'])) {
        $image_id = $_POST['image_id']; // Get image ID from the request
        $caption = $_POST['caption'];
        $name = $_POST['name']; // Get name from the request
        $media_type = "image"; // Assuming we are only dealing with images

        // Check if an image is being uploaded
        if (isset($_FILES['my_image']) && $_FILES['my_image']['error'] === 0) {
            $image_name = $_FILES['my_image']['name'];
            $tmp_name = $_FILES['my_image']['tmp_name'];
            $image_ex = pathinfo($image_name, PATHINFO_EXTENSION);
            $image_ex_lc = strtolower($image_ex);
            $allowed_exs = array("jpg", 'jpeg', 'png', 'gif', 'bmp');

            if (in_array($image_ex_lc, $allowed_exs)) {
                // Ensure the uploads directory exists
                if (!is_dir('uploads')) {
                    mkdir('uploads', 0755, true);
                }

                $new_image_name = uniqid("image-", true) . '.' . $image_ex_lc;
                $image_upload_path = 'uploads/' . $new_image_name;
                move_uploaded_file($tmp_name, $image_upload_path);

                // Full URL for the image
                $image_url = "uploads/" . $new_image_name;

                // Update the image path, caption, and name in the database using PDO
                $stmt = $pdo->prepare("UPDATE login SET caption = ?, reels_video = ?, media_type = ?, name = ? WHERE id = ?");
                $stmt->execute([$caption, $image_url, $media_type, $name, $image_id]);

                if ($stmt->rowCount() > 0) {
                    echo "Image updated successfully! Image URL: " . $image_url;
                } else {
                    echo "No changes made or image not found.";
                }
            } else {
                echo "You can't upload files of this type.";
            }
        } else {
            // If no new image is uploaded, just update the caption and name
            $stmt = $pdo->prepare("UPDATE login SET caption = ?, name = ? WHERE id = ?");
            $stmt->execute([$caption, $name, $image_id]);

            if ($stmt->rowCount() > 0) {
                echo "Caption and name updated successfully!";
            } else {
                echo "No changes made or image not found.";
            }
        }
    } else {
        echo "Invalid input.";
    }
} catch (PDOException $e) {
    echo "Database Error: " . $e->getMessage();
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>