


<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// अगर POST request है तो upload handle करो
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json'); // ✅ JSON सिर्फ POST पर

    // Database connection
    $host = 'localhost';
    $dbname = 'dreams';
    $username = 'root';
    $password = '';

    try {
        $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'error' => 'Connection failed: ' . $e->getMessage()]);
        exit;
    }

    if (isset($_POST['caption'], $_FILES['my_image'], $_POST['user_id'])) {
        $caption = trim($_POST['caption']);
        $user_id = (int)$_POST['user_id'];
        $category = isset($_POST['category']) ? trim($_POST['category']) : 'General';

        $allowed_exs = ["jpg", "jpeg", "png", "gif", "mp4", "mov"];
        $uploadedFiles = [];

        foreach ($_FILES['my_image']['name'] as $index => $filename) {
            $file_ex = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

            if (!in_array($file_ex, $allowed_exs)) {
                continue; // skip invalid file type
            }

            $new_file_name = uniqid("wallpaper-", true) . '.' . $file_ex;
            $file_upload_path = 'uploads/' . $new_file_name;

            if (move_uploaded_file($_FILES['my_image']['tmp_name'][$index], $file_upload_path)) {
                $media_type = in_array($file_ex, ["mp4", "mov"]) ? "video" : "image";

                try {
                    $stmt = $connection->prepare(
                        "INSERT INTO wallpapers (caption, file_url, media_type, user_id, category) 
                         VALUES (?, ?, ?, ?, ?)"
                    );
                    $stmt->execute([$caption, $file_upload_path, $media_type, $user_id, $category]);
                    $wallpaper_id = $connection->lastInsertId();

                    $uploadedFiles[] = [
                        'wallpaper_id' => $wallpaper_id,
                        'media_url' => $file_upload_path,
                        'media_type' => $media_type
                    ];
                } catch (PDOException $e) {
                    continue;
                }
            }
        }

        if (!empty($uploadedFiles)) {
            echo json_encode(['success' => true, 'files' => $uploadedFiles]);
        } else {
            echo json_encode(['success' => false, 'error' => 'No valid files uploaded']);
        }
        exit;
    } else {
        echo json_encode(['success' => false, 'error' => 'Required fields missing']);
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Upload Wallpapers</title>
  <style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    .preview-container { display: flex; flex-wrap: wrap; gap: 10px; margin-top: 15px; }
    .preview-box {
      position: relative;
      width: 120px; height: 120px;
      border: 2px solid #ccc;
      border-radius: 8px;
      overflow: hidden;
    }
    .preview-box img, .preview-box video {
      width: 100%; height: 100%; object-fit: cover;
    }
    .select-number {
      position: absolute;
      top: 5px; left: 5px;
      background: rgba(0,0,0,0.6);
      color: #fff;
      padding: 3px 6px;
      font-size: 12px;
      border-radius: 4px;
    }
  </style>
</head>
<body>
  <h2>Upload Wallpapers</h2>

  <form id="uploadForm" enctype="multipart/form-data" method="POST">
    <label>Caption: </label>
    <input type="text" name="caption" required><br><br>

    <label>User ID: </label>
    <input type="number" name="user_id" value="1" required><br><br>

    <label>Category: </label>
    <input type="text" name="category" placeholder="General"><br><br>

    <label>Select Files: </label>
    <input type="file" id="fileInput" name="my_image[]" multiple required><br><br>

    <button type="submit">Upload</button>
  </form>

  <div class="preview-container" id="previewContainer"></div>

  <script>
    const fileInput = document.getElementById("fileInput");
    const previewContainer = document.getElementById("previewContainer");

    // Preview selected files
    fileInput.addEventListener("change", () => {
      previewContainer.innerHTML = "";
      Array.from(fileInput.files).forEach((file, index) => {
        const reader = new FileReader();
        reader.onload = (e) => {
          const div = document.createElement("div");
          div.classList.add("preview-box");

          if (file.type.startsWith("video/")) {
            div.innerHTML = `
              <span class="select-number">${index + 1}</span>
              <video src="${e.target.result}" controls></video>
            `;
          } else {
            div.innerHTML = `
              <span class="select-number">${index + 1}</span>
              <img src="${e.target.result}" alt="Preview">
            `;
          }
          previewContainer.appendChild(div);
        };
        reader.readAsDataURL(file);
      });
    });

    // Ajax form submit
    document.getElementById("uploadForm").addEventListener("submit", async (e) => {
      e.preventDefault();
      const formData = new FormData(e.target);

      try {
        const response = await fetch("", {
          method: "POST",
          body: formData
        });
        const data = await response.json();
        alert(JSON.stringify(data, null, 2));
      } catch (error) {
        alert("Upload failed: " + error);
      }
    });
  </script>
</body>
</html>
