<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Upload Form</title>
</head>
<body>
    <h1>Upload Your Video</h1>
    <form action="" method="post" enctype="multipart/form-data">
        <label for="user_id">User ID:</label>
        <input type="text" id="user_id" name="user_id" required><br><br>

        <label for="caption">Caption:</label>
        <input type="text" id="caption" name="caption" required><br><br>

        <label for="my_video">Select Video:</label>
        <input type="file" id="my_video" name="my_video" accept="video/*" required><br><br>

        <button type="submit">Upload Video</button>
    </form>

    <?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection details
$host = 'localhost';
$dbname = 'dreams';
$username = 'root'; // Replace with your actual database username
$password = ''; // Replace with your actual database password

try {
    // Create a PDO connection
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die(json_encode(['error' => 'Connection failed: ' . $e->getMessage()]));
}

// Check if form data is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate required fields
    if (!isset($_FILES['my_video']) || !isset($_POST['user_id']) || !isset($_POST['caption'])) {
        die(json_encode(['error' => 'Required fields are missing.']));
    }

    $video_name = $_FILES['my_video']['name'];
    $tmp_name = $_FILES['my_video']['tmp_name'];
    $error = $_FILES['my_video']['error'];

    // Get the user ID and caption from POST data
    $user_id = (int)$_POST['user_id']; // Ensure user_id is an integer
    $caption = htmlspecialchars($_POST['caption']); // Sanitize caption

    // Validate file upload
    if ($error !== UPLOAD_ERR_OK) {
        die(json_encode(['error' => "Error uploading video. Error code: $error"]));
    }

    // Validate file extension
    $video_ex = pathinfo($video_name, PATHINFO_EXTENSION);
    $video_ex_lc = strtolower($video_ex);
    $allowed_exs = array("mp4", 'webm', 'avi', 'flv');

    if (!in_array($video_ex_lc, $allowed_exs)) {
        die(json_encode(['error' => "You can't upload files of this type."]));
    }

    // Generate a unique file name for the video
    $new_video_name = uniqid("video-", true) . '.' . $video_ex_lc;
    $video_upload_path = 'uploads/' . $new_video_name;

    // Ensure the uploads directory exists
    if (!is_dir('uploads')) {
        mkdir('uploads', 0777, true);
    }

    // Move the uploaded video file to the uploads directory
    if (!move_uploaded_file($tmp_name, $video_upload_path)) {
        die(json_encode(['error' => "Failed to move uploaded video file."]));
    }

    // Handle thumbnail upload if provided
    $thumbnail_name_only = null;
    if (isset($_FILES['thumbnail']) && $_FILES['thumbnail']['error'] === UPLOAD_ERR_OK) {
        $thumbnail_name = $_FILES['thumbnail']['name'];
        $thumbnail_tmp = $_FILES['thumbnail']['tmp_name'];
        $thumbnail_ex = pathinfo($thumbnail_name, PATHINFO_EXTENSION);
        $thumbnail_ex_lc = strtolower($thumbnail_ex);

        // Validate thumbnail file extension
        $allowed_thumbnail_exs = array("jpg", "jpeg", "png");
        if (!in_array($thumbnail_ex_lc, $allowed_thumbnail_exs)) {
            die(json_encode(['error' => "You can't upload thumbnail files of this type."]));
        }

        // Generate a unique file name for the thumbnail
        $new_thumbnail_name = uniqid("thumbnail-", true) . '.' . $thumbnail_ex_lc;
        $thumbnail_upload_path = 'uploads/' . $new_thumbnail_name;

        // Move the uploaded thumbnail file to the uploads directory
        if (!move_uploaded_file($thumbnail_tmp, $thumbnail_upload_path)) {
            die(json_encode(['error' => "Failed to move uploaded thumbnail file."]));
        }
        
        $thumbnail_name_only = $new_thumbnail_name;
    }

    // Insert just the filenames into the database (without 'uploads/' prefix)
    $media_type = "video";

    try {
        // Prepare and execute the SQL statement using PDO
        $stmt = $connection->prepare("INSERT INTO video (caption, reels_video, thumbnail, media_type, user_id) VALUES (:caption, :reels_video, :thumbnail, :media_type, :user_id)");
        $stmt->bindValue(':caption', $caption);
        $stmt->bindValue(':reels_video', $new_video_name); // Just the filename
        $stmt->bindValue(':thumbnail', $thumbnail_name_only); // Just the filename (can be null)
        $stmt->bindValue(':media_type', $media_type);
        $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->execute();

        // Get the ID of the newly inserted video
        $video_id = $connection->lastInsertId();

        // Return success response with the video data
        echo json_encode([
            'success' => true,
            'video' => [
                'id' => $video_id,
                'caption' => $caption,
                'reels_video' => $new_video_name,
                'thumbnail' => $thumbnail_name_only,
                'user_id' => $user_id
            ]
        ]);
    } catch (PDOException $e) {
        die(json_encode(['error' => 'Database error: ' . $e->getMessage()]));
    }
} else {
    echo json_encode(['error' => 'Invalid request method.']);
}
?>
</body>
</html>