

<?php
header('Content-Type: application/json');
$host = 'localhost'; 
$dbname = 'dreams'; 
$u = 'root'; 
$p = '';
$base_url = "http://10.136.188.139/dreams/";

try {
    $db = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $u, $p);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  //  $post_id = $_POST['post_id'] ?? null;
  //  $current_user = $_POST['current_user'] ?? null;
$post_id = $_POST['post_id'] ?? $_GET['post_id'] ?? null;
$current_user = $_POST['current_user'] ?? $_GET['current_user'] ?? null;

    
    if (!$post_id) throw new Exception('Missing post_id');

    // Check columns
    $columns = $db->query("SHOW COLUMNS FROM commentse")->fetchAll(PDO::FETCH_COLUMN);
    $has_like_count = in_array('like_count', $columns);
    $has_parent_username = in_array('parent_username', $columns);
    $has_reels_video = in_array('reels_video', $columns);
    $has_created_at = in_array('created_at', $columns); // ✅ Check if 'created_at' exists

    // Check if comment_likes table exists
    $likeSystemExists = false;
    try {
        $db->query("SELECT 1 FROM comment_likes LIMIT 1");
        $likeSystemExists = true;
    } catch (PDOException $e) {
        $likeSystemExists = false;
    }

    // Build SELECT fields
    $selectFields = [
        'c.id', 
        'c.post_id', 
        'c.username', 
        'c.comment', 
        'c.is_gif', 
        'c.gif_url', 
        'c.parent_id',
        'c.replies_count',
        $has_like_count ? 'IFNULL(c.like_count, 0) AS like_count' : '0 AS like_count',
        $has_parent_username ? 'c.parent_username' : 'NULL AS parent_username',
        $has_reels_video ? 'c.reels_video' : 'NULL AS reels_video',
        'l.reels_video AS login_reels_video',
        'l.id AS login_id',
        'l.name AS login_name',
        'l.caption AS login_caption'
    ];

    if ($has_created_at) {
        $selectFields[] = 'c.created_at'; // ✅ Add created_at to SELECT
    }

    if ($likeSystemExists && $current_user) {
        $selectFields[] = '(SELECT COUNT(*) FROM comment_likes cl WHERE cl.comment_id = c.id) AS likeCount';
        $selectFields[] = 'IFNULL((SELECT 1 FROM comment_likes cl WHERE cl.comment_id = c.id AND cl.username = :current_user LIMIT 1), 0) AS isLiked';
    } else {
        $selectFields[] = ($has_like_count ? 'IFNULL(c.like_count, 0)' : '0') . ' AS likeCount';
        $selectFields[] = '0 AS isLiked';
    }

    // Final query with JOIN
    $query = "SELECT " . implode(', ', $selectFields) . " 
              FROM commentse c
              LEFT JOIN login l ON c.username = l.username
              WHERE c.post_id = :post_id
              ORDER BY c.created_at ASC";

    $stmt = $db->prepare($query);
    $stmt->bindParam(':post_id', $post_id);
    if ($likeSystemExists && $current_user) {
        $stmt->bindParam(':current_user', $current_user);
    }

    $stmt->execute();
    $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Process base_url for reels_video
    foreach ($comments as &$row) {
        if (!empty($row['reels_video']) && strpos($row['reels_video'], $base_url) === false) {
            $row['reels_video'] = $base_url . $row['reels_video'];
        }
        if (!empty($row['login_reels_video']) && strpos($row['login_reels_video'], $base_url) === false) {
            $row['login_reels_video'] = $base_url . $row['login_reels_video'];
        }
    }

    // Format response
    $formattedComments = array_map(function($comment) use ($has_created_at) {
        return [
            'id' => (int)$comment['id'],
            'post_id' => $comment['post_id'],
            'username' => $comment['username'],
            'comment' => $comment['comment'],
            'is_gif' => (int)$comment['is_gif'],
            'gif_url' => $comment['gif_url'],
            'parent_id' => $comment['parent_id'] ? (int)$comment['parent_id'] : null,
            'like_count' => (int)$comment['like_count'],
            'replies_count' => (int)$comment['replies_count'],
            'parent_username' => $comment['parent_username'] ?? null,
            'reels_video' => $comment['reels_video'] ?? null,
            'likeCount' => (int)$comment['likeCount'],
            'isLiked' => (bool)$comment['isLiked'],
            'created_at' => $has_created_at ? $comment['created_at'] : null, // ✅ Add created_at in output
            'user' => [
                'id' => $comment['login_id'] ?? null,
                'name' => $comment['login_name'] ?? null,
                'caption' => $comment['login_caption'] ?? null,
                'reels_video' => $comment['login_reels_video'] ?? null,
            ]
        ];
    }, $comments);

    echo json_encode($formattedComments);
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>
