



<?php
header('Content-Type: application/json');

$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $comment_id = $_POST['comment_id'] ?? null;
    $username = $_POST['username'] ?? null;
    $action = $_POST['action'] ?? 'like'; // 'like' or 'unlike'

    if (!$comment_id || !$username) {
        throw new Exception('Missing required fields');
    }

    $connection->beginTransaction();

    if ($action === 'like') {
        // Check if already liked
        $check = $connection->prepare("SELECT id FROM comment_likes WHERE comment_id = ? AND username = ?");
        $check->execute([$comment_id, $username]);
        
        if ($check->rowCount() > 0) {
            throw new Exception('User already liked this comment');
        }

        // Add like record
        $stmt = $connection->prepare("INSERT INTO comment_likes (comment_id, username) VALUES (?, ?)");
        $stmt->execute([$comment_id, $username]);

        // Update like count
        $update = $connection->prepare("UPDATE commentse SET like_count = like_count + 1 WHERE id = ?");
        $update->execute([$comment_id]);
    } else {
        // Remove like record
        $stmt = $connection->prepare("DELETE FROM comment_likes WHERE comment_id = ? AND username = ?");
        $stmt->execute([$comment_id, $username]);

        // Update like count
        $update = $connection->prepare("UPDATE commentse SET like_count = GREATEST(like_count - 1, 0) WHERE id = ?");
        $update->execute([$comment_id]);
    }

    // Get updated like count
    $count = $connection->prepare("SELECT like_count FROM commentse WHERE id = ?");
    $count->execute([$comment_id]);
    $like_count = $count->fetchColumn();

    $connection->commit();

    echo json_encode([
        'status' => 'success',
        'like_count' => $like_count
    ]);
} catch (PDOException $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>