<?php
header('Content-Type: application/json');

// Database connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get POST data
    $comment_id = $_POST['comment_id'] ?? null;
    $username = $_POST['username'] ?? null;

    if (!$comment_id || !$username) {
        throw new Exception('Missing required fields');
    }

    // First check if the comment belongs to the user
    $checkSql = "SELECT username FROM commentse WHERE id = :comment_id";
    $checkStmt = $connection->prepare($checkSql);
    $checkStmt->bindParam(':comment_id', $comment_id);
    $checkStmt->execute();
    
    $comment = $checkStmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$comment || $comment['username'] != $username) {
        throw new Exception('You can only delete your own comments');
    }

    // Start transaction
    $connection->beginTransaction();

    // Delete the comment
    $deleteSql = "DELETE FROM commentse WHERE id = :comment_id";
    $deleteStmt = $connection->prepare($deleteSql);
    $deleteStmt->bindParam(':comment_id', $comment_id);
    
    if (!$deleteStmt->execute()) {
        throw new Exception('Failed to delete comment');
    }

    $connection->commit();

    echo json_encode([
        'status' => 'success',
        'message' => 'Comment deleted successfully'
    ]);
} catch (PDOException $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>