
<?php
include "db_conn.php";

// Get the post_id from the query parameters
$post_id = isset($_GET['post_id']) ? intval($_GET['post_id']) : 0;

// Prepare the SQL statement to get the comments with user info
$sql = "SELECT
            commentse.*, 
            login.reels_video, 
            login.id as login_id, 
            login.name, 
            login.caption
        FROM commentse 
        LEFT JOIN login ON commentse.username = login.username 
        WHERE commentse.post_id = ?";

$stmt = mysqli_prepare($conn, $sql);

if ($stmt) {
    // Bind the post_id parameter
    mysqli_stmt_bind_param($stmt, 'i', $post_id);

    // Execute the statement
    if (mysqli_stmt_execute($stmt)) {
        $res = mysqli_stmt_get_result($stmt);
        $comments = array();

        if (mysqli_num_rows($res) > 0) {
            while ($row = mysqli_fetch_assoc($res)) {
                $comments[] = array(
                    'comment_id' => $row['id'],
                    'post_id' => $row['post_id'],
                    'username' => $row['username'],
                    'comment' => $row['comment'], // assuming this field exists
                    'created_at' => $row['created_at'],
                    'user_info' => array(
                        'user_id' => $row['login_id'],
                        'name' => $row['name'],
                        'caption' => $row['caption'],
                        'reels_video' => $row['reels_video']
                    )
                );
            }
        }

        $response = array(
            'status' => 'success',
            'count' => count($comments),
            'comments' => $comments
        );
    } else {
        $response = array(
            'status' => 'error',
            'message' => 'Failed to execute query: ' . mysqli_error($conn)
        );
    }
} else {
    $response = array(
        'status' => 'error',
        'message' => 'Failed to prepare statement: ' . mysqli_error($conn)
    );
}

// Close statement and connection
if (isset($stmt)) mysqli_stmt_close($stmt);
mysqli_close($conn);

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>