<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection details
$host = 'localhost';
$dbname = 'dreams';
$username = 'root'; // Replace with your actual database username
$password = ''; // Replace with your actual database password

try {
    // Connect to the database using PDO
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the post ID and username from the request
    $post_id = isset($_POST['post_id']) ? $_POST['post_id'] : null;
    $username = isset($_POST['username']) ? $_POST['username'] : null;

    // Validate input data
    if (!$post_id || !$username) {
        die("Invalid input data.");
    }

    // Query to check if the user has liked the post
    $query = "SELECT * FROM likese WHERE post_id = :post_id AND username = :username";
    $stmt = $connection->prepare($query);
    $stmt->execute([
        ':post_id' => $post_id,
        ':username' => $username
    ]);

    // Fetch the result
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if the user has liked the post
    if ($result) {
        echo 'true';
    } else {
        echo 'false';
    }
} catch (PDOException $e) {
    // Handle database errors
    die("Database error: " . $e->getMessage());
}
?>