

<?php
// Connect to MySQL database
$conn = new mysqli("localhost", "dreams", "", "root");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to check if a user is a follower of another user
function is_follower($user_id, $follow_id, $conn) {
    $query = "SELECT * FROM follows WHERE user_id = '$user_id' AND follow_id = '$follow_id'";
    $result = $conn->query($query);
    return $result->num_rows > 0;
}

// Function to get like count for a post
function get_like_count($post_id, $conn) {
    $query = "SELECT COUNT(*) as like_count FROM likes WHERE post_id = '$post_id'";
    $result = $conn->query($query);
    $row = $result->fetch_assoc();
    return $row['like_count'];
}

// Function to get account content for a user
function get_account_content($user_id, $viewer_id, $conn) {
    // Change this query to use the login table
    $query = "SELECT is_private FROM login WHERE id = '$user_id'";
    $result = $conn->query($query);
    
    if ($result->num_rows == 0) {
        return json_encode(array("message" => "User  not found."));
    }
    
    $row = $result->fetch_assoc();
    $is_private = $row['is_private'];

    if ($is_private == 1) {
        // Check if viewer is a follower of the private account
        if (is_follower($viewer_id, $user_id, $conn)) {
            // Return text content if viewer is a follower
            return fetch_reels_with_likes($user_id, $conn);
        } else {
            // Return message if viewer is not a follower
            return json_encode(array("message" => "This account is private."));
        }
    } else {
        // Return public content if account is not private
        return fetch_reels_with_likes($user_id, $conn);
    }
}

// Function to fetch reels with like counts
function fetch_reels_with_likes($user_id, $conn) {
    $query = "SELECT * FROM reels_videose WHERE user_id = '$user_id'";
    $result = $conn->query($query);
    $account_content = array();
    
    while ($row = $result->fetch_assoc()) {
        $post_id = $row['id']; // Assuming 'id' is the primary key for reels_video
        $row['like_count'] = get_like_count($post_id, $conn); // Add like count to the post data
        $account_content[] = $row;
    }
    
    return json_encode($account_content);
}

// Check if the request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if the user_id and viewer_id are set
    if (isset($_POST["user_id"]) && isset($_POST["viewer_id"])) {
        $user_id = $_POST["user_id"];
        $viewer_id = $_POST["viewer_id"];
        $account_content = get_account_content($user_id, $viewer_id, $conn);
        echo $account_content;
    } else {
        echo json_encode(array("message" => "User  ID and Viewer ID are required."));
    }
} else {
    echo json_encode(array("message" => "Invalid request method."));
}

$conn->close();
?>