<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuration
$db_host = 'localhost';
$db_username = 'root';
$db_password = '';
$db_name = 'dreams';

// Connect to the database
$conn = new mysqli($db_host, $db_username, $db_password, $db_name);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the video ID and username from the request
$video_id = $_POST['video_id'];
$username = $_POST['username'];

// Prepare and execute the SQL query using prepared statements
$stmt = $conn->prepare("INSERT INTO video_watches (video_id, username) VALUES (?, ?)");
if ($stmt === false) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("ss", $video_id, $username); // "ss" means two string parameters

if ($stmt->execute()) {
    echo "Video watch recorded successfully";
} else {
    echo "Error recording video watch: " . $stmt->error;
}

// Close the statement and database connection
$stmt->close();
$conn->close();
?>