




<?php
// DB Connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

$pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Required values
$user_id = $_GET['user_id'];
$caption_filter = isset($_GET['caption_filter']) ? $_GET['caption_filter'] : '';

// FINAL SQL
$sql = "
SELECT 
    rv.id,
    rv.caption,
    rv.reels_video,
    rv.thumbnail,
    rv.user_id,
    rv.created_at,

    l.username,
    l.name,
    l.caption AS user_caption,
    l.reels_video AS user_reels_video,

    -- LIKE COUNT
    COALESCE(like_counts.like_count, 0) AS like_count,

    -- VIEW COUNT
    COALESCE(views.view_count, 0) AS view_count

FROM video rv

-- Check if this user already interacted/viewed the video
LEFT JOIN user_reelsvideo_interactions uri
    ON rv.id = uri.video_id AND uri.user_id = :user_id

LEFT JOIN login l ON rv.user_id = l.id

-- LIKE COUNTS
LEFT JOIN (
    SELECT post_id, COUNT(*) AS like_count
    FROM likes
    GROUP BY post_id
) AS like_counts
    ON rv.id = like_counts.post_id

-- VIEW COUNTS
LEFT JOIN (
    SELECT video_id, COUNT(*) AS view_count
    FROM user_reelsvideo_interactions
    WHERE viewed = 1
    GROUP BY video_id
) AS views
    ON rv.id = views.video_id

WHERE 
    -- IMPORTANT: user must NOT have viewed it
    (uri.viewed IS NULL OR uri.viewed = 0)

    AND rv.caption LIKE :caption_filter

GROUP BY rv.id

-- RANDOM RESULT ORDER
ORDER BY RAND()
";

// Prepare & Bind
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id);

$caption_filter = '%' . $caption_filter . '%';
$stmt->bindParam(':caption_filter', $caption_filter);

$stmt->execute();

// Fetch results
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// BASE URLS
$base_url = 'http://10.91.25.51/dreams/uploads/';
$base_urls = 'http://10.91.25.51/dreams/';

// Add URLs in response
foreach ($results as &$result) {
    if (!empty($result['reels_video'])) {
        $result['reels_video'] = $base_url . $result['reels_video'];
    }
    if (!empty($result['thumbnail'])) {
        $result['thumbnail'] = $base_url . $result['thumbnail'];
    }
    if (!empty($result['user_reels_video'])) {
        $result['user_reels_video'] = $base_urls . $result['user_reels_video'];
    }
}
unset($result);

// Output JSON
header('Content-Type: application/json');
echo json_encode($results);
?>
