

<?php
// db connect
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

// ✅ baseUrl (Flutter वाला जैसा)
$baseUrl = "http://10.144.183.51/dreams/";

$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]));
}

$user_id = $_POST['user_id'] ?? $_GET['user_id'] ?? null;

if (!$user_id) {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
    exit;
}

// wallpaper_id निकालो wallpaper_save से
$query = $conn->prepare("SELECT wallpaper_id FROM wallpaper_save WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
$query->bind_param("i", $user_id);
$query->execute();
$result = $query->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $wallpaper_id = $row['wallpaper_id'];

    // अब wallpapers table से row निकालो
    $wp_query = $conn->prepare("SELECT * FROM wallpapers WHERE id = ?");
    $wp_query->bind_param("i", $wallpaper_id);
    $wp_query->execute();
    $wp_result = $wp_query->get_result();

    if ($wp_result->num_rows > 0) {
        $wallpaper = $wp_result->fetch_assoc();

        // ✅ file_url में baseUrl जोड़ो
        if (!empty($wallpaper['file_url'])) {
            $wallpaper['file_url'] = $baseUrl . $wallpaper['file_url'];
        }

        echo json_encode(["success" => true, "wallpaper" => $wallpaper]);
    } else {
        echo json_encode(["success" => false, "message" => "Wallpaper not found"]);
    }

    $wp_query->close();
} else {
    echo json_encode(["success" => false, "message" => "No wallpaper saved for this user"]);
}

$query->close();
$conn->close();
?>
