<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "pushy_demo";

// FCM server key (from Firebase Console > Project Settings > Cloud Messaging)
$serverKey = 'YOUR_FCM_SERVER_KEY';

$conn = new mysqli($servername, $username, $password, $dbname);

// Check latest message
$sql = "SELECT * FROM messages ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $userId = $row['user_id'];
    $message = $row['message'];

    // Get FCM token for the user
    $tokenQuery = "SELECT fcm_token FROM users WHERE user_id = '$userId'";
    $tokenResult = $conn->query($tokenQuery);

    if ($tokenResult->num_rows > 0) {
        $tokenRow = $tokenResult->fetch_assoc();
        $fcmToken = $tokenRow['fcm_token'];

        // Send FCM push notification
        $notification = [
            'to' => $fcmToken,
            'notification' => [
                'title' => "New Message",
                'body' => $message,
                'sound' => 'default'
            ]
        ];

        $headers = [
            'Authorization: key=' . $serverKey,
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notification));

        $response = curl_exec($ch);
        curl_close($ch);

        echo "Notification sent: " . $response;
    } else {
        echo "No FCM token found for user $userId.";
    }
} else {
    echo "No messages found.";
}

$conn->close();
?>
