




<?php
header("Content-Type: application/json");
require_once 'db_connect.php';

// 🌐 Base URL for media
$baseUrl = "http://10.161.116.51/dreams/";

// ✅ Get user ID from request
$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;

$response = ['success' => false, 'stories' => []];

if (!$userId) {
    $response['message'] = 'User ID is required';
    echo json_encode($response);
    exit;
}

try {
    // ✅ Get stories by matching story_thubnal → stories → login tables
    $stmt = $pdo->prepare("
        SELECT 
            s.id,
            s.user_id,
            s.media_url,
            s.media_type,
            s.created_at,
            s.expires_at,
            s.music_url,
            s.gradient_index,
            s.navigate,
            l.username,
            l.reels_video,
            t.story_thubnal AS reels_video
        FROM story_thubnal t
        INNER JOIN stories s 
            ON t.post_id = s.id  -- Match story_thubnal.post_id with stories.id
        INNER JOIN login l 
            ON s.user_id = l.id  -- Get user details from login table
        WHERE t.user_id = ?  -- Filter by the requested user_id
        ORDER BY s.created_at DESC
    ");
    $stmt->execute([$userId]);

    $stories = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($stories)) {
        $response['message'] = 'No stories found for this user';
        $response['success'] = true;
        echo json_encode($response);
        exit;
    }

    // 🔹 Add URL prefix to media paths
    foreach ($stories as &$story) {
        if (!empty($story['media_url'])) {
            $story['media_url'] = $baseUrl . $story['media_url'];
        }
        if (!empty($story['reels_video'])) {
            $story['reels_video'] = $baseUrl . $story['reels_video'];
        }
        if (!empty($story['story_thubnal'])) {
            $story['story_thubnal'] = $baseUrl . $story['story_thubnal'];
        }
        
        // 🔹 Convert datetime formats if needed
        $story['created_at'] = date('Y-m-d H:i:s', strtotime($story['created_at']));
        $story['expires_at'] = date('Y-m-d H:i:s', strtotime($story['expires_at']));
    }
    unset($story); // Break reference

    // 🔹 Wrap each story in its own array
    $response['success'] = true;
    $response['stories'] = array_map(function($story) {
        return [$story];
    }, $stories);
    
    $response['count'] = count($stories);

} catch (PDOException $e) {
    $response['message'] = "Database error: " . $e->getMessage();
    error_log("Database error in stories API: " . $e->getMessage());
}

echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>