

 <?php
// Database connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$base_url = "http://10.91.25.51/dreams/";

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Get current user_id
$current_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($current_user_id <= 0) {
    echo json_encode(["error" => "Invalid user_id"]);
    exit;
}

// Step 1: Get related user_ids
$sql = "
    SELECT DISTINCT follow_id AS related_user_id
    FROM follows
    WHERE user_id = ?
    UNION
    SELECT DISTINCT user_id AS related_user_id
    FROM follows
    WHERE follow_id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$current_user_id, $current_user_id]);
$related_users = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Step 2: Add self
$related_users[] = $current_user_id;

// Step 3: Get username
$stmt = $pdo->prepare("SELECT username FROM login WHERE id = ?");
$stmt->execute([$current_user_id]);
$current_username = $stmt->fetchColumn();
if (!$current_username) {
    echo json_encode(["error" => "User not found"]);
    exit;
}

// Step 4: Get watched videos
$stmt = $pdo->prepare("SELECT video_id FROM video_watches WHERE username = ?");
$stmt->execute([$current_username]);
$watched_videos = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Step 5: Placeholders
$related_placeholders = implode(',', array_fill(0, count($related_users), '?'));
$watched_placeholders = !empty($watched_videos) ? implode(',', array_fill(0, count($watched_videos), '?')) : null;

// Step 6: Common SELECT (✅ Added music_url)
$select_with_joins = "
    SELECT 
        rv.id,
        rv.user_id,
        l.username,
        l.name,
        rv.caption,
        l.caption AS user_caption,
        CONCAT(?, rv.reels_video) AS media_url,
        CONCAT(?, l.reels_video) AS user_reels_url,
        CONCAT(?, rv.thumbnail) AS thumbnail,
        CONCAT(?, rv.music_url) AS music_url, -- ✅ Added this line
        rv.media_type AS type,
        rv.created_at,
        (SELECT COUNT(*) FROM likese WHERE post_id = rv.id) AS like_count,
        'reels_videose' AS source_table
    FROM reels_videose rv
    JOIN login l ON rv.user_id = l.id
";

// Params
$params_related = array_merge([$base_url, $base_url, $base_url, $base_url], $related_users);
$params_non_related = array_merge([$base_url, $base_url, $base_url, $base_url], $related_users);

// Step 7: Related users query — RANDOM unseen
$sql_related = "$select_with_joins WHERE rv.user_id IN ($related_placeholders)";
if ($watched_placeholders) {
    $sql_related .= " AND rv.id NOT IN ($watched_placeholders)";
    $params_related = array_merge($params_related, $watched_videos);
}
$sql_related .= " ORDER BY RAND() LIMIT 1";

// Step 8: Non-related users query — RANDOM unseen
$sql_non_related = "$select_with_joins WHERE rv.user_id NOT IN ($related_placeholders)";
if ($watched_placeholders) {
    $sql_non_related .= " AND rv.id NOT IN ($watched_placeholders)";
    $params_non_related = array_merge($params_non_related, $watched_videos);
}
$sql_non_related .= " ORDER BY RAND() LIMIT 1";

// Step 9: Execute
$stmt = $pdo->prepare($sql_related);
$stmt->execute($params_related);
$related_video = $stmt->fetch(PDO::FETCH_ASSOC);

if ($related_video) {
    $single_video = $related_video;
} else {
    $stmt = $pdo->prepare($sql_non_related);
    $stmt->execute($params_non_related);
    $non_related_video = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($non_related_video) {
        $single_video = $non_related_video;
    } else {
        // ✅ Step 10: Fallback (अगर सारे videos देख लिए तो कोई भी random video दे दो)
        $sql_fallback = $select_with_joins . " ORDER BY RAND() LIMIT 1";
        $stmt = $pdo->prepare($sql_fallback);
        $stmt->execute([$base_url, $base_url, $base_url, $base_url]); // ✅ Added 4 base_urls for music_url too
        $single_video = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}

// Output JSON
header('Content-Type: application/json');
echo json_encode($single_video, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>
