<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$base_url = "http://10.91.25.51/dreams/";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode(["error" => "DB Connection failed: " . $e->getMessage()]);
    exit;
}

// Get current user_id
$current_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($current_user_id <= 0) {
    echo json_encode(["error" => "Invalid user_id"]);
    exit;
}

// Step 1: Get related user_ids
$sql = "
    SELECT DISTINCT follow_id AS related_user_id
    FROM follows
    WHERE user_id = ?
    UNION
    SELECT DISTINCT user_id AS related_user_id
    FROM follows
    WHERE follow_id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$current_user_id, $current_user_id]);
$related_users = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Step 2: Add self
$related_users[] = $current_user_id;

// Step 3: Get username
$stmt = $pdo->prepare("SELECT username FROM login WHERE id = ?");
$stmt->execute([$current_user_id]);
$current_username = $stmt->fetchColumn();

if (!$current_username) {
    echo json_encode(["error" => "User not found"]);
    exit;
}

// Step 4: Get watched videos
$stmt = $pdo->prepare("SELECT video_id FROM video_watches WHERE username = ?");
$stmt->execute([$current_username]);
$watched_videos = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Step 5: Prepare placeholders
$related_placeholders = implode(',', array_fill(0, count($related_users), '?'));
$watched_placeholders = !empty($watched_videos)
    ? implode(',', array_fill(0, count($watched_videos), '?'))
    : null;

// Step 6: Common SELECT
$select_with_joins = "
    SELECT 
        rv.id,
        rv.user_id,
        l.username,
        l.name,
        rv.caption,
        l.caption AS user_caption,
        CONCAT(?, rv.reels_video) AS media_url,
        CONCAT(?, l.reels_video) AS user_reels_url,
        CONCAT(?, rv.thumbnail) AS thumbnail,
        CONCAT(?, rv.music_url) AS music_url,
        rv.media_type AS type,
        rv.created_at,
        (SELECT COUNT(*) FROM likese WHERE post_id = rv.id) AS like_count,
        'reels_videose' AS source_table
    FROM reels_videose rv
    JOIN login l ON rv.user_id = l.id
";

$select_params = [$base_url, $base_url, $base_url, $base_url];

// ======================================
// STEP 7: RELATED USERS QUERY (LIMIT 2)
// ======================================
$sql_related = "$select_with_joins WHERE rv.user_id IN ($related_placeholders)";
$params_related = array_merge($select_params, $related_users);

if ($watched_placeholders) {
    $sql_related .= " AND rv.id NOT IN ($watched_placeholders)";
    $params_related = array_merge($params_related, $watched_videos);
}

$sql_related .= " ORDER BY RAND() LIMIT 2";

$stmt = $pdo->prepare($sql_related);
$stmt->execute($params_related);
$related_videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// If related videos found → Process them
if (!empty($related_videos)) {
    $final = applyTypeFilter($related_videos, $pdo, $base_url);
    echo json_encode($final, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

// ======================================
// STEP 8: NON-RELATED USERS QUERY (LIMIT 2)
// ======================================
$sql_non_related = "$select_with_joins WHERE rv.user_id NOT IN ($related_placeholders)";
$params_non_related = array_merge($select_params, $related_users);

if ($watched_placeholders) {
    $sql_non_related .= " AND rv.id NOT IN ($watched_placeholders)";
    $params_non_related = array_merge($params_non_related, $watched_videos);
}

$sql_non_related .= " ORDER BY RAND() LIMIT 2";

$stmt = $pdo->prepare($sql_non_related);
$stmt->execute($params_non_related);
$non_related_videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!empty($non_related_videos)) {
    $final = applyTypeFilter($non_related_videos, $pdo, $base_url);
    echo json_encode($final, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

// ======================================
// STEP 9: FALLBACK — RANDOM 2 VIDEOS
// ======================================
$sql_fallback = $select_with_joins . " ORDER BY RAND() LIMIT 2";

$stmt = $pdo->prepare($sql_fallback);
$stmt->execute($select_params);
$fallback_videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// FINAL FILTER
$final = applyTypeFilter($fallback_videos, $pdo, $base_url);
echo json_encode($final, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
exit;


// =====================================================
// FUNCTION — Enforce Rules (1 Video + 1 Image OR 2 Images)
// =====================================================
function applyTypeFilter($items, $pdo, $base_url)
{
    $videos = array_values(array_filter($items, fn($v) => $v['type'] === 'video'));
    $images = array_values(array_filter($items, fn($v) => $v['type'] === 'image'));

    // ❌ Case: 2 Videos (NOT ALLOWED)
    if (count($videos) >= 2) {

        // STEP 1: If any IMAGE already in items → use it
        if (!empty($images)) {
            return [
                $videos[0],
                $images[0]
            ];
        }

        // STEP 2: Try fetching one image from DB
        global $select_with_joins;

        $sql = "
            SELECT 
                rv.*,
                CONCAT('$base_url', rv.reels_video) AS media_url,
                CONCAT('$base_url', rv.thumbnail) AS thumbnail,
                'image' AS type
            FROM reels_videose rv
            WHERE rv.media_type = 'image'
            ORDER BY RAND()
            LIMIT 1
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $oneImage = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($oneImage) {
            return [
                $videos[0],
                $oneImage
            ];
        }

        // STEP 3: No image in DB → return default image
        return [
            $videos[0],
            [
                "id" => 0,
                "user_id" => 0,
                "username" => "system",
                "name" => "system",
                "caption" => "default image",
                "user_caption" => "",
                "media_url" => $base_url . "default.jpg",
                "thumbnail" => "",
                "music_url" => "",
                "type" => "image",
                "created_at" => date("Y-m-d H:i:s"),
                "like_count" => 0,
                "source_table" => "system"
            ]
        ];
    }

    // ✔ Allowed (Images + Videos mix)
    return $items;
}

?>
