'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"flutter_bootstrap.js": "5a733c607788000acef8e4a9f9774b83",
"version.json": "ecb7f4fdfd7b7603cd571873c4e8f519",
"index.html": "469e236b289f01378b60b52d8fac4741",
"/": "469e236b289f01378b60b52d8fac4741",
"main.dart.js": "26ad0d8d00d77d11396497551492cc10",
"flutter.js": "76f08d47ff9f5715220992f993002504",
"favicon.png": "327644db5bf914ee3d0f7a04a5a23f03",
"icons/Icon-192.png": "416ac33b2e0037a5bf26132b7608d0f9",
"icons/Icon-maskable-192.png": "be7e184c38a693423e5fcc9bafe46b92",
"icons/Icon-maskable-512.png": "7b6c460a49a63dba7c7848640e9ce3c4",
"icons/Icon-512.png": "7b6c460a49a63dba7c7848640e9ce3c4",
"manifest.json": "90136fc0c97442ce02eba17605d21f52",
"assets/AssetManifest.json": "4f557f4373a51ba6684f6d7a3020ba5c",
"assets/NOTICES": "8cf6a62d3dabe77bf2c5f8bded57f2e2",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/AssetManifest.bin.json": "20d030f98e68da6fa2e58674857cf166",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "33b7d9392238c04c131b6ce224e13711",
"assets/packages/flutter_dino/assets/images/sprite.png": "1876fad2b35fa1f8e5c7c0f0e3f476cc",
"assets/packages/wakelock_plus/assets/no_sleep.js": "7748a45cd593f33280669b29c2c8919a",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/AssetManifest.bin": "9f6707e422ddb111bbeaacaf86d14ada",
"assets/fonts/MaterialIcons-Regular.otf": "82ce711c4b53744f176c89bf452430dc",
"assets/assets/Screenshot%25202025-12-30%2520at%25203.44.59%25E2%2580%25AFAM.png": "0040df22b9afb039592cfa1a1e41b8be",
"assets/assets/apple_731985.png": "9357892adb4e37ba5b5f7e64e923b05d",
"assets/assets/p11.png": "c908bb1ff0e5af990b7f2b8b1233453d",
"assets/assets/app.png": "69affdc4cc129179ed0939bd454d96af",
"assets/assets/vision3.png": "0293834a0d600494c58caf9d976357f1",
"assets/assets/vision.png": "09c74f098439b9571d956e79e5b00521",
"assets/assets/social-bg.png": "a7afdf37c023d6776d37ee2f9c74efd3",
"assets/assets/Screenshot%25202025-12-28%2520at%25208.53.21%25E2%2580%25AFPM.png": "799565a4cad7dcd70031d350290fd194",
"assets/assets/-29.jpg": "e0817638bb42cc3c940832d17c8a23c3",
"assets/assets/Dreamsa.png": "32443e3589c7c206cb35419e2da7c1e5",
"assets/assets/vision1.png": "e903fdaf29b3da02bcfad2df8719ff10",
"assets/assets/The_Secret_Language_of_Cells_and_How_to_Speak_It_Chris_Bahl_TED_1080P.mp4": "5bd1773fc950310f9e3ee4c0ee07ff77",
"assets/assets/Untitled%2520(19).png": "3a75c68298a8678853fb7164ed2ae785",
"assets/assets/pur.png": "0ff2689ddc2978ca6abc724a8740eac8",
"assets/assets/smiling-datisfied-entrepreneur-holds-papers-wears-casual-clothes-prepares-training-workshop-reads-necessary-information-analyzes-documentation-poses-against-cafe-interior-working-conditions.jpg": "1916f67a67179dd5e998fc7f76d2a9c4",
"assets/assets/story_dreams.png": "59fcfcb318065a2fd0108ae6f283aa8f",
"assets/assets/Untitled%2520(23).png": "1f771f40583b10b7a1fccf2b4a38fc9b",
"assets/assets/p9.png": "e1cf3660cadbdb9047798fa966ba06c2",
"assets/assets/portrait-man-working-laptop.jpg": "058bd22c7bcd19fb9f40fc7736ca2b7c",
"assets/assets/Untitled__16_-removebg-preview.png": "1f10ab3bf5a83285bb2b4b7a2de62abd",
"assets/assets/example4.png": "47e1b5d6464b5062ac559eb44f66efaa",
"assets/assets/p8.png": "cc1eed4b57de32d7883f4d853e905292",
"assets/assets/android-logo_14415.png": "aad5d86ecd87788ec2e33aaf617dba5f",
"assets/assets/profile_iphone.png": "0ddf586beb4a2c36cbeb2baf32fde8af",
"assets/assets/home.png": "6e05281652284249ebfffe04f4710820",
"assets/assets/but1.png": "b689fcd7500828d911e513f6d3d7eb6f",
"assets/assets/Screenshot%25202025-12-30%2520at%25203.45.52%25E2%2580%25AFAM.png": "f522d56545c6dfbf86b726df227fa744",
"assets/assets/Midnight.png": "88c567494f0620dc807077210a421d2e",
"assets/assets/example1.png": "cd4e01ee85a709ca143fb352a32114ba",
"assets/assets/example3.png": "160e221354b98791dee76c7492c39e5e",
"assets/assets/story123.png": "121de5cdab13ffddd7563503b6cf52d2",
"assets/assets/but2.png": "b82972f887aeb48c32d1155ff63e67bb",
"assets/assets/x-twitter.png": "3810057f1dd18b7c9deaeced7022c7df",
"assets/assets/example2.png": "06390adfd2efed7a9edfe12a29d192de",
"assets/assets/profile_iphone1.png": "5ab503672fd1cad5286b92b231cf18e5",
"assets/assets/Untitled%2520(21).png": "4dd864f2b71a516a136b6b39db14069e",
"assets/assets/missing2.png": "09fa4b09e563007234a597e831b6ac2c",
"assets/assets/web1.png": "f8d5d19bae31e61ecf3febb42a27938e",
"assets/assets/p0.png": "ef733c1821759836ca60a30987465770",
"assets/assets/intro2.png": "0c2ad350077b7e149bb7ddcbcc4ffdfe",
"assets/assets/Graphite.png": "6366461f7903273a2fa2c9c5c6eb272e",
"assets/assets/missing1.png": "9515e2f33a926b652161a45e0b00e314",
"assets/assets/web2.png": "55a26cd1dcc011d6f623860251493e23",
"assets/assets/p1.png": "54687a049412435b357dbe61f838095e",
"assets/assets/Madhubala_cover_-_Amit_Trivedi_1080P.mp4": "64750cc5f90720a659017ee6e6636973",
"assets/assets/p6.png": "2524b157c952691751e6f4dfd4134724",
"assets/assets/clapper.png": "d3efbfe18a0b41846eb710e6cda5dcc5",
"assets/assets/web.png": "5e056e6d60c578ceb246ac6d7a598ba6",
"assets/assets/Untitled%2520(20).png": "4c1978fc11fd196aa8fbaca07a211ac0",
"assets/assets/ds.png": "360d7f846882763dbe95e8b9e83c18c7",
"assets/assets/p7.png": "dd1cc9ff76d186d8623a641ed2443adf",
"assets/assets/Untitled.png": "3227544eb4023d2312bca441680cb0bf",
"assets/assets/person-indian-origin-having-fun.jpg": "24f1a496a3498855ea5c6b0215ce7ae0",
"assets/assets/cs.png": "42576e32074be9a6a2487ddbdfdefb94",
"assets/assets/video-6932764f3131d9.42793188.mp4": "6e9ae73d900161f83efc3d1b7a89360f",
"assets/assets/D.png": "ff0eb6f9469b03f7e575b03e34a750ea",
"assets/assets/p.png": "2225cd43601f5c4c688cb6ba7367796f",
"assets/assets/Screenshot%25202025-12-30%2520at%25203.47.11%25E2%2580%25AFAM.png": "76884f3526b99c7c652d9b1f74213d0d",
"assets/assets/but.png": "2c5e15ab215daa55322f9c2f937030a1",
"assets/assets/missing.png": "54a5a15fad7e3d5e38ee126216460144",
"assets/assets/snapchat.png": "685a8650d82fd993e7e3afbb9ec24de2",
"assets/assets/user-4.png": "676907fc64841525dcad75caf88d2844",
"canvaskit/skwasm_st.js": "d1326ceef381ad382ab492ba5d96f04d",
"canvaskit/skwasm.js": "f2ad9363618c5f62e813740099a80e63",
"canvaskit/skwasm.js.symbols": "80806576fa1056b43dd6d0b445b4b6f7",
"canvaskit/canvaskit.js.symbols": "68eb703b9a609baef8ee0e413b442f33",
"canvaskit/skwasm.wasm": "f0dfd99007f989368db17c9abeed5a49",
"canvaskit/chromium/canvaskit.js.symbols": "5a23598a2a8efd18ec3b60de5d28af8f",
"canvaskit/chromium/canvaskit.js": "ba4a8ae1a65ff3ad81c6818fd47e348b",
"canvaskit/chromium/canvaskit.wasm": "64a386c87532ae52ae041d18a32a3635",
"canvaskit/skwasm_st.js.symbols": "c7e7aac7cd8b612defd62b43e3050bdd",
"canvaskit/canvaskit.js": "6cfe36b4647fbfa15683e09e7dd366bc",
"canvaskit/canvaskit.wasm": "efeeba7dcc952dae57870d4df3111fad",
"canvaskit/skwasm_st.wasm": "56c3973560dfcbf28ce47cebe40f3206"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
